/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Adc.c
  \brief    	
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	6/27/2008 9:51:50 AM
  
  * History:
  
*/
/****************************************************************************************/
#include "Adc.h"

/** Holds the ADC result from any of the RFIFO buffers */
static uint16_t u16AdcConvResult = 0;
static uint32_t u32RawAdc75Ref = 0;
static uint32_t u32RawAdc25Ref = 0;
static uint32_t Result = 0;         /* ADC conversion result  */
/****************************************************************************************/
/**
 * \brief     Initialize Adc0 module with Predefined parameters established at \n
              Adc_Cfg.h file.
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   This function shall be invoked once at initialization.
 */  
void vfnAdc_Init(void)
{
  /* Writes a Configuration Command */
  //EQADC.CFPR[0].R = ADC_CONFIGURATION_2;       /* Send CFIFO 0 a ADC0 configuration command */
  ADC_WRITE_CONFIG_CMD(au32Adc_Config_Params[ADC_ASSIGNED_CONFIG_PARAMS],ADC_FIFO_BUFFER);
  /* Triggers ADC channel 0 using CFIFO 1        */
  ADC_WRITE_CONTROL_CMD(ADC_CTRL_CMD_1,ADC_FIFO_BUFFER);
  /* Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0*/
  ADC_DMA_CR(ADC_FIFO_BUFFER,0x0303);  
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Enabled         */
         /*	CFIFO Underflow Interrupt is : Enabled      */
         /*	CFIFO Fill Enable is : Enabled              */
         /*	CFIFO Fill Select : DMA                     */
         /*	RFIFO Overflow Interrupt is : Enabled       */
         /*	RFIFO Drain is : Enabled                    */
         /*	RFIFO Drain Select is : DMA                 */

  /* Wait for End Of Queue flag    */
  while (ADC_END_OF_QUEUE_FLAG(ADC_FIFO_BUFFER) != 1) {} 
  /* Clear End Of Queue flag       */
  ADC_END_OF_QUEUE_FLAG(ADC_FIFO_BUFFER) = 1;     
}

/****************************************************************************************/
/**
 * \brief     Start ADC conversion on the indicated channel
 * \author    R01160
 * \param     Adc Channel to Convert, Enable/Disable Calibration Bit
 * \return    none
 */  
void vfnStart_Conversion_fnc(uint8_t u8AdcChannel, uint32_t u32Calibration)
{
	  /* Load Queue with predefined command  */
	  cQUEUE0 = (uint32_t)0x80000000;//((uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u8AdcChannel << 8) | (uint32_t)u32Calibration);
	  /* Disable DMA trigerring                 */
	  ADC_DMA_CR(ADC_FIFO_BUFFER,0x0000);  
	  /* Invalidate  command queue 0            */ 
	  ADC_INVALIDATE_CFIFO(ADC_FIFO_BUFFER);        
	  /* Enable DMA triggering                  */
	  ADC_DMA_CR(ADC_FIFO_BUFFER,0x0303);  
	  /* Set ADC Mode as Single Scan Sw Trigger */
	  EQADC.CFCR[ADC_FIFO_BUFFER].B.MODE = SW_TRIG_SS;
	  /* Set SSE bit on CFCRx register          */
	  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);
   	  
}

/****************************************************************************************/
/**
 * \brief     Read an ADC result from a desired ADC channel. 
 * \author    R01160
 * \param     none
 * \return    ADC result returned in 16-bit
 */  
uint16_t u16Read_Adc_Result(uint8_t u8AdcFifoBuffer)
{
  
  while (EQADC.FISR[0].B.RFDF != 1){}      /* Wait for RFIFO 0's Drain Flag to set */
  //Result = EQADC.RFPR[0].R;                /* ADC result */        
  EQADC.FISR[0].B.RFDF = 1;                /* Clear RFIFO 0's Drain Flag */
  EQADC.FISR[0].B.EOQF = 1;                /* Clear CFIFO's End of Queue flag */ 
  
  return((uint16_t)rQUEUE0);	

}

/****************************************************************************************/
/**
 * \brief     calculates ADC calibration values and write those values into \n
              GCC & OCC registers
 * \author    R01160
 * \param     Buffer number (FIFO)
 * \return    none
 * \warning   This function shall be invoked once at initialization.
 */  
void vfnInitAdc_Calibration(uint32_t u32dac)
{
  uint32_t i;
  /* These variables holds internal ADC reference voltages */
  uint32_t u32vr25, u32vr75;
  /* Arm configuration commands                            */
  uint32_t u32ArmCmd = 0;
  /* Holds gcc and occ final values to be written into GCC & OCC registers */
  uint32_t u32gcc, u32occ;

  
  ADC_WRITE_CONFIG_CMD((0x002c2b00 + (u32dac<<25)), ADC_FIFO_BUFFER_0); /* channel == 43 (0x2b) 3/4VRH  */                  
  ADC_WRITE_CONFIG_CMD((0x803c2c00 + (u32dac<<25)), ADC_FIFO_BUFFER_0); /* channel == 44 (0x2c) 1/4VRH  */                 
  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);                                  /* software trigger             */

  for (i=0;i<20000;i++){ ;; }    	                                 /* make sure all conversions are finished */

/* get results */
  u32vr75 = ADC_READ_RESULT(ADC_FIFO_BUFFER_0);	 /* 75%*VRH */
  u32vr25 = ADC_READ_RESULT(ADC_FIFO_BUFFER_1);	 /* 25%*VRH  */

/* Calculate calibration gain and offset */
  u32gcc = (ADC_75_REF_CHANNEL - ADC_25_REF_CHANNEL)<<14;
  u32gcc = u32gcc / (u32vr75 - u32vr25);
  u32occ = u32gcc * u32vr75;
  u32occ = u32occ>>14;
  u32occ = ADC_75_REF_CHANNEL - u32occ -2;

  u32gcc = u32gcc << 8;
  u32occ = u32occ << 8;
  u32gcc = (uint32_t)((uint32_t)0x00ffff00 & (uint32_t)u32gcc);
  u32occ = (uint32_t)((uint32_t)0x00ffff00 & (uint32_t)u32occ);

  /* Assembling command to write into gcc register   */
  u32ArmCmd = (uint32_t)((uint32_t)0x00000004 | (uint32_t)u32gcc | (uint32_t)(u32dac<<25));
  /* write gcc register                              */                    
  ADC_WRITE_CONFIG_CMD(u32ArmCmd,ADC_FIFO_BUFFER_0);                
  /* Assembling command to write into OCC register   */
  u32ArmCmd = (uint32_t)((uint32_t)0x80000005 | (uint32_t)u32occ | (uint32_t)(u32dac<<25));
  /* Write occ                                       */
  ADC_WRITE_CONFIG_CMD(u32ArmCmd,ADC_FIFO_BUFFER_0); 
   /* Software trigger                               */
  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);                  

  
} /* end of Calibrate */

